---
aliases: Product Vision
---
Creating impactful product strategy portfolio: [#ProductCon NY '23: Impactful Product Innovation by Michelle Parsons](https://www.youtube.com/watch?v=d26fx5ZXtXI&ab_channel=ProductSchool)

### Moats 
##### AI product SaaS or enterprise AI
- System of record
- Workflow lock-in
- Deep integrations
- Customer relationships 

### Vision: 
A good product vision is a **short** statement describing the **difference** your new **product** makes in the **world**

##### Commerce Platform Vision: 
Create best in class commerce experiences agnostic to type of commerce UI to maximize revenue at lowest cost of infrastructure and efficient developer experience.

### Company mission statements
**Adobe**: Changing the world through digital experiences
**Airbnb**: Create a world where anyone can belong anywhere
**Amazon**: be Earth's most customer-centric company
**Apple**: To build the best technology products for customers
**Disney**: To entertain, inform and inspire people through power of storytelling and innovative technologies
**Facebook, Meta**: Build the future of human connection and the technology that makes it possible
**Google**: to organize the world's information and make it universally accessible and useful
**LinkedIn**: Create economic opportunity for every member of the global workforce
**Microsoft**: Empower every human and every organization to achieve more
**Netflix**: we want to entertain the world
**PayPal**: Democratize financial services
**Reddit**: Bringing community and belonging to everyone in the world
**Shopify**: make commerce better for everyone
**Spotify**: unblock potential of human creativity
**Stripe**: increasing global GDP of internet
**Tesla**: To accelerate world’s transition to sustainable energy
**Uber**: Transportation for everyone
**Zoom**: AI-first work platform for human connection 

### Example Product Vision for: an API product in commerce platform
When creating a product vision document for an API product in a commerce platform, it's important to include key sections that provide a clear understanding of the product's purpose, goals, and roadmap. Here are some suggested sections to include:
1. Introduction:
	- Overview: Provide a high-level overview of the API product and its role within the commerce platform.
	- Objectives: Clearly state the objectives and goals of the API product, such as improving user experience, increasing revenue, or enhancing integration capabilities.
2. Target Audience:
	- Identify the target audience for the API product, such as developers, partner organizations, or third-party applications.
	- Describe their needs, pain points, and expectations from the API product.
3. Product Vision:
	- Present a concise and inspiring vision statement that encapsulates the long-term goals and impact of the API product.
	- Explain how the API product aligns with the overall vision and strategy of the commerce platform.
4. Use Cases and Value Proposition:
	- Identify and describe the key use cases that the API product addresses.
	- Highlight the unique value proposition that the API product brings to its users, such as simplified integration, enhanced functionality, or improved performance.
5. API Features and Functionality:
	- Provide a detailed description of the core features and functionality offered by the API product.
	- Explain how these features solve specific problems or address the needs of the target audience.
6. Integration and Compatibility:
	- Outline the compatibility of the API product with various platforms, technologies, and programming languages.
	- Discuss any existing integrations or potential partnerships that enhance the API product's capabilities.
7. Performance and Scalability:
	- Discuss the performance characteristics and scalability of the API product, including response times, data throughput, and capacity planning.
	- Highlight any strategies or technologies implemented to ensure high performance and scalability.
8. Roadmap and Future Enhancements:
	- Provide a high-level roadmap for the API product, including planned releases and major feature enhancements.
	- Outline future development and expansion plans based on market trends, customer feedback, and business priorities.
9. Developer Resources and Support:
	- Explain the availability of developer resources, such as documentation, SDKs, code samples, and testing environments.
	- Describe the support mechanisms, including forums, community engagement, and dedicated developer support channels.
10. Metrics and Success Criteria:
	- Define key performance indicators (KPIs) and success criteria that will be used to evaluate the effectiveness and impact of the API product.
	- Specify how these metrics align with the overall business objectives and track the product's progress towards achieving them.
11. Risks and Mitigation Strategies:
	- Identify potential risks, challenges, or obstacles that may impact the success of the API product.
	- Propose mitigation strategies or contingency plans to address these risks and ensure smooth product delivery.
12. Stakeholders and Collaboration:
	- Identify the key stakeholders involved in the development, implementation, and adoption of the API product.
	- Outline the collaboration and communication strategies to engage stakeholders and foster a shared understanding of the product vision.

Remember, this is a general guideline, and you can adapt it based on your specific product and organization. The document should provide a clear and compelling vision that aligns with the business goals while addressing the needs of the target audience.

## Product Strategy: 
##### Definition:
Set of **choices** you make as a product team to play a specific market based on set of **assumptions or hypotheses**, so that those choices will **help you win that market and create advantage for your company**.

##### From: [Laura Marino | LinkedIn](https://www.linkedin.com/posts/shyveeshi_productmanagement-careers-b2b-activity-7077802890601365504-U77G?utm_source=share&utm_medium=member_ios)
A product strategy describes, at a high level, the necessary steps to get to the state described in the product vision. Therefore, the definition of a product strategy needs to follow the definition of the company vision.

Difficult task of allocating resources correctly to balance long term vision with short term business demands.
- More difficult in B2B as strong opinionated stakeholders exist - sales team, client success team, few big customers, regulatory conditions
- Combination of top-down and bottoms-up approach is needed to balance investments for optimizing between product/business outcomes and tech debt
##### Key aspects of strategy: 
1. What problem you’re solving?
2. Target audience - which customer segment you are targeting?
3. Value proposition - how your solution addresses the problem?
4. Competitive advantage - why is your product better than competitors or substitutes?
5. Growth strategy - what will be the sustainable growth strategy to acquire customers?
6. Business model - what’s the monetization model?

##### Examples
- Example: Southwest
	Decided to bet on short distance flights, assumed customers want slightly better than greyhound train experience and not many frills (no food, cushy executive class cabin or other premier services)    
    Operated on point-to-point model rather than industry’s hub and spoke model to operate flights
    When someone is planning set of actions from a checklist, others may already be working on a winning strategy to win markets.
- Uber
- 
### Porter’s five forces & eCommerce
1. **Supplier power** - low cause the ecommerce brand controls which products to build and sell, suppliers do not have many options
2. **Buyer power** - high cause switching costs are too low. Buyer can just visit another website of a smaller player.
3. **Threat of substitute products** - high. Physical retail is always a substitute and other e-commerce businesses too
4. **Threat of new entrants** - high cause cost of entry is low when launching eCommerce website. However, it gets low if there’s a large warehouse investment needed. Barrier to entry could get high.
5. **Industry rivalry** - high cause global and local brands exist as direct rivals.

### From book - How to measure your life -
“A strategy—whether in companies or in life—is created through hundreds of everyday decisions about how you spend your time, energy, and money. With every moment of your time, every decision about how you spend your energy and your money, you are making a statement about what really matters to you. You can talk all you want about having a clear purpose and strategy for your life, but ultimately this means nothing if you are not investing the resources you have in a way that is consistent with your strategy. In the end, a strategy is nothing but good intentions unless it’s effectively implemented. How do you make sure that you’re implementing the strategy you truly want to implement? Watch where your resources flow—the resource allocation process. If it is not supporting the strategy you’ve decided upon, you run the risk of a serious problem. You might think you are a charitable person, but how often do you really give your time or money to a cause or an organization that you care about? If your family matterf me in a week, does[…]”

##### Reasons products fail: 
[The Root Causes of Product Failure by Marty Cagan at Mind the Product San Francisco - YouTube](https://www.youtube.com/watch?v=9dccd8lihpQ&ab_channel=MindtheProduct)

##### Apple and Innovator’s dilemma:
Christensen’s theory: For any market disruption, a vertically integrated approach is successful at first, but then lower end module products bring features that are ‘good-enough’ to users that disrupts the vertical integrator and eventually the good-enough feature products become better than the vertical integrator.

Christensen’s theory is based on examples drawn from buying decisions made by _businesses, not consumers._
The reason this matters is that the theory of low-end disruption presumes:
- Buyers are rational
    - But consumers aren’t rational. They fall for instant gratification, advertisements, lack of product knowledge.
    - Buyers on the other hand need to justify their decisions to their managers and so they need to be rational in making purchase decisions.
- Every attribute that matters can be documented and measured
    - For consumers, the softer attributes - impulses, feelings are hard to measure and cannot be documented (yet). Enjoyable products create more excitement for consumers and those with purchasing power will choose to spend on more premium experience.
    - For buyers, we know what matters to them, cost, features are all comparable and documentable.
- Modular providers can become “good enough” on all the attributes that matter to the buyers
    - Modularization incurs costs in the design and experience of using products that cannot be overcome, yet cannot be measured. Business buyers – and the analysts who study them – simply ignore them, but consumers don’t.
    - Some consumers inherently know and value quality, look-and-feel, and attention to detail, and are willing to pay a premium that far exceeds the financial costs of being vertically integrated.
All three of the assumptions fail in the consumer market, and this, ultimately, is why Christensen’s theory fails as well

## Interview questions
"If you were CEO of our company, what would you build?"
Everyone from Amazon to Walmart asks this nowadays.
And - most test it in 45-minute cases.
In fact, of all PM interview case types, the strategy type is the third most ubiquitous.
In order:
1. ﻿﻿﻿Sense
2. ﻿﻿﻿Design
3. ﻿﻿﻿Strategy
4. ﻿﻿﻿Execution
5. ﻿﻿﻿Technical

So, it's we'll worth understanding all 7 variants of the Product Strategy Case:
1. Tech Company Strategy - What should X's vision/strategy be?
2. Mergers & Acquisitions - Should X buy Y?
3. Real-World Strategy - How would you improve the strategy of X real-world scenario?
4. Product Improvement - How can X product be improved?
5. Market Entry - Should company X get into Y space?
6. New Tech × Business - How would you build a business around X new tech?
7. Product Monetization - How would you improve the monetization of X?